// priority: 10
// 1. 找到下面的 `自定义盔甲套装` 列表。
// 2. 完整地复制一个已有的套装例子（从 `{` 开始，到 `}` 结束，别忘了后面的逗号）。
// 3. 把复制的内容粘贴到列表的末尾。
// 4. 修改你粘贴的这个新套装的各个属性，把它变成你想要的样子。
//
//  - "TIP信息": [(介绍加成显示说明, 必须填写!),格式 kubejs.set.tip.xxx.1, kubejs.set.tip.xxx.2, ...]
//  - "套装内部名称": (字符串, 必须填写!)
//    这是套装的“身份证号”，必须是独一无二的，不能和别的套装重名。
//    例如: "不朽龙王套", "深渊漫步者之靴"
//
//  - "部件": (可选)
//    这里填写套装需要的盔甲和手持物品。如果你的套装全是饰品，可以不写这一整项。
//    键名必须是: "头盔", "胸甲", "裤衩", "靴子", "主手", "副手"。
//    值是物品的ID，例如: "minecraft:diamond_helmet"。
//
//  - "饰品": (可选)
//    这里定义套装需要的饰品，是实现各种酷炫效果的核心！
//
//    a) 【简单格式】单个饰品，无任何要求:
//       直接写上饰品的ID字符串就行。
//       饰品: [ "enigmaticlegacy:iron_ring" ]
//
//    b) 【对象格式】定义一个有额外要求的饰品:
//       如果要对一个饰品做更复杂的设定，必须把它写成一个对象。
//       饰品: [
//         {
//           id: "enigmaticlegacy:iron_ring",   // 饰品本身的ID
//           count: 2,                         // (可选) 要求玩家必须佩戴2个这个饰品
//           前置饰品: "enigmaticlegacy:iron_amulet" // (可选) 戴这个戒指前，必须先戴着铁护符
//         }
//       ]
//       *注意*: 在对象格式中，`id` 是必需的，其他属性是可选的。
//
//    c) 【高级格式】需要多个不同的前置饰品:
//       `前置饰品` 字段可以是一个数组，来要求玩家同时佩戴多个指定的饰品。
//       {
//         id: "enigmaticaddons:master_ring",
//         前置饰品: [
//           "enigmaticlegacy:iron_ring",    // 需求1: 必须戴着一个铁戒指
//           "enigmaticlegacy:gold_ring"     // 需求2: 必须戴着一个金戒指
//         ]
//       }
//
//   d) 【选择性格式】前置饰品二选一或多选一：
//      如果前置条件是一个数组里面又套了一个数组，代表“或”逻辑。
//      {
//        id: "enigmaticaddons:choice_medallion",
//        前置饰品: [
//          ["enigmaticlegacy:iron_ring", "enigmaticlegacy:gold_ring"] // 需求：戴铁戒指 或 戴金戒指 都可以
//        ]
//      }
//
//   e) 【互斥格式】与某些饰品不能同时佩戴 (新增功能!):
//      使用 `互斥饰品` 属性，来定义一个“黑名单”。
//      {
//        id: "modid:fire_ring",
//        互斥饰品: "modid:ice_ring" // 如果玩家已经戴着冰霜戒指，就无法戴上火焰戒指
//      }
//      *`互斥饰品` 也可以是一个数组，来定义多个不能共存的饰品。*
//
// - "免疫效果列表": (可选)
//   一个列表，写上这个套装可以免疫的药水效果ID。
//   例如: [ "minecraft:poison", "minecraft:wither" ]
//
// - "飞行能力": (可选)
//   想让这个套装能飞吗？加上这行就行！
//   飞行能力: ["开启"]
//
// - "效果列表": (可选)
//   给穿上套装的玩家加点“BUFF”。可以是 "属性" 或 "药水"。
//   - "属性" 效果 (永久加成):
//     {
//       类型: "属性",
//       作用属性: "minecraft:generic.movement_speed", // 想修改的属性ID (例如: 移速)
//       uuid: "a1b2c3d4-e5f6-a7b8-c9d0-e1f2a3b4c5d6", // *必须* 是一个独一无二的UUID，不能和其他属性效果重复！
//       效果显示名称: "套装移速加成",
//       数值: 0.1,                                   // 加成的数值
//       计算操作: "增加"                              // "增加", "设置为", "总倍率" 三选一
//     }
//   - "药水" 效果 (临时加成):
//     {
//       类型: "药水",
//       药水ID: "minecraft:speed",
//       等级: 0,                                     // 可选, 0=I级, 1=II级... 默认为0
//       时长: 2                                     // 可选, 持续时间(秒), 2秒, 默认为2
//     }
//
// - "免疫伤害列表": (可选)
//   让套装能抵抗甚至免疫某些伤害。
//   - 【完全免疫】: 直接写上伤害类型的中文名（需在脚本的映射表中定义）或英文ID。
//     例如: "火焰", "燃烧"
//   - 【伤害减免】: 定义一个对象，键是伤害类型，值是一个乘数 (0.0到1.0之间)。
//     例如: { "玩家爆炸": 0.25 } // 受到的玩家爆炸伤害只剩25% (减免了75%)
//     例如: { "摔落": 0.0 }     // 完全免疫摔落伤害
//
// - "攻击附加效果": (可选)
//   让你的攻击带上“毒”！
//   - 效果对象:
//     {
//       效果ID: "minecraft:wither",     // 给敌人上的药水效果ID
//       时长: 5,                     // 持续时间 (秒)
//       等级: 1,                       // 效果等级 (0=I, 1=II, ...)
//       显示粒子: true,                 // 要不要显示粒子效果
//       概率: 0.25,                    // (可选) 25%的几率触发。不写就是100%触发。
//       目标条件: ["怪物", "玩家"]       // (可选) 只对某些类型的生物生效。不写就对所有生物生效。
//     }
// ---
// UUID生成器: (请访问 https://uutool.cn/uuid/ ) 警告! 确保每个 "属性" 效果的UUID都是独一无二的!

// --- 伤害类型映射表 ---
// 将中文名映射到游戏内部的伤害标识符(msgId)。
// 如果您在 `免疫伤害列表` 中使用了中文名，请确保它在这里有对应的条目。
// 您可以通过在游戏中受到某种伤害，并查看控制台日志来获取新的 msgId。
let 伤害ID中文名映射表 = {
    "燃烧": "onFire",
    "火焰": "inFire",
    "岩浆": "lava",
    "岩浆块": "hotFloor",
    "挤压": "cramming",
    "溺水": "drown",
    "摔落": "fall",
    "撞击": "flyIntoWall",
    "仙人掌": "cactus",
    "窒息": "inWall",
    "落物": "fallingBlock",
    "甜浆果": "sweetBerryBush",
    "爆炸": "explosion",
    "玩家爆炸": "player_explosion",
    "玩家": "player",
    "魔法": "magic",
    "虚空": "outOfWorld"
};

global.自定义盔甲套装 = [
  /*{
    TIP信息: [
      "§6- 虚空转换",
    ],
    套装内部名称: "虚空转换",
    饰品: ["enigmaticlegacy:super_magnet_ring"],
    // 效果列表，添加药水效果或属性加成
    效果列表: [
    ],
    免疫效果列表: [
      "minecraft:poison", // 中毒
    ],
    攻击附加效果: [
      {
               效果ID: "minecraft:wither",     // 给敌人上的药水效果ID
               时长: 5,                     // 持续时间 (秒)
               等级: 1,                       // 效果等级 (0=I, 1=II, ...)
               显示粒子: true,                 // 要不要显示粒子效果
               概率: 0.95,                    // (可选) 25%的几率触发。不写就是100%触发。
               目标条件: ["怪物", "玩家"]       // (可选) 只对某些类型的生物生效。不写就对所有生物生效。
             }
    ],
      免疫伤害列表: [
      "全部伤害",          // 完全免疫所有伤害 (allDamage)
      {"全部伤害": 0.8},   // 受到全部伤害时，只承受80%的伤害 (减免20%)
      "火焰",                // 完全免疫站在火方块里受到的伤害 (inFire)
      "燃烧",                // 完全免疫身上着火的持续伤害 (onFire)
      { "摔落": 0.0 },       // 受到摔落伤害时，伤害乘以0，等同于完全免疫 (fall)
      { "魔法": 0.8 }        // 受到魔法伤害时，只承受80%的伤害 (减免20%)
    ]
},*/
  {
    TIP信息: [
      "§6- 创造飞行",
      "§6- 纯净之躯",
      "§6- 盔甲+30",
      "§6- 盔甲韧性+10",
      "§6- 速度+0.04",
      "§6- 常驻伤害减免40%，低于70%血后增加60%伤害减免",
      "§6- 你对法术的掌控无与伦比",
      "§6- 你对元素的掌控无与伦比",
      "§6- 你的生命恢复能力得到极大的提高，免疫自然伤害",
    ],
    套装内部名称: "紫极星源套",
    部件: {
      头盔: "eternisstarrysky:infinity_eternal_helmet", 胸甲: "eternisstarrysky:infinity_eternal_chestplate",
      裤衩: "eternisstarrysky:infinity_eternal_leggings", 靴子: "eternisstarrysky:infinity_eternal_boots"
    },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "4db662d8-ebe7-496d-a8e7-65d017a4cba2", 效果显示名称: "紫极星源套 护甲值", 数值: 30.0, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "d7462773-1771-45c1-a8f6-2c2c27522f0a", 效果显示名称: "紫极星源套 护甲韧性", 数值: 10.0, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "3b45e711-200f-4660-95c1-4181df17374a", 效果显示名称: "紫极星源套 移动速度", 数值: 0.04, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "obscure_api:regeneration", uuid: "f8a3e112-0f5c-4b1a-984e-0d7b6a1e0f2d", 效果显示名称: "紫极星源套 生命再生", 数值: 20, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "419c6fb9-061c-48ef-8be7-1717d1bba3a4", 效果显示名称: "紫极星源套 施法时间缩减", 数值: 0.5, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "a2b8d5f0-1e8c-4f7a-a8d1-f0e1d3c5b7a9", 效果显示名称: "紫极星源套 法力恢复", 数值: 0.5, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "c5e0a9f3-2d7b-4c6a-b9f8-e2d4c7b9a1f0", 效果显示名称: "紫极星源套 冷却缩减", 数值: 0.5, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:max_mana", uuid: "35dea721-0a5a-4fc3-a7e7-42ba43cbe535", 效果显示名称: "紫极星源套最大法力值", 数值: 800, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_power", uuid: "d5e34fef-e5dc-4ffb-ac3f-fdb666fa3799", 效果显示名称: "紫极星源套法术强度", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_resist", uuid: "593bfacb-6033-4cd6-9502-aa538a4cbab6", 效果显示名称: "紫极星源套法术抗性", 数值: 0.5, 计算操作: "总倍率" }
    ],
    免疫伤害列表: ["火焰", "燃烧", "岩浆", "岩浆块", "仙人掌", "甜浆果", "撞击", "窒息", "溺水", { "摔落": 0.0 }, { "魔法": 0.8 }, {"全部伤害": 0.6}],
  },
  {
    TIP信息: [
      "§6- 幸运+3",
      "§6- 移速+0.03",
    ],
    套装内部名称: "纸板套",
    部件: { 头盔: "create:cardboard_helmet", 胸甲: "create:cardboard_chestplate", 裤衩: "create:cardboard_leggings", 靴子: "create:cardboard_boots", },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "ac4b4a25-75be-4b26-a82d-af43bd6e33a6", 效果显示名称: "纸板套 移动速度", 数值: 0.03, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.luck", uuid: "bedd104d-7df8-40a4-949e-9d5857da204b", 效果显示名称: "纸板套 幸运", 数值: 3, 计算操作: "增加" },
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+8",
      "§6- 盔甲韧性+4",
      "§6- 移速增加20%",
    ],
    套装内部名称: "娜迦套",
    部件: { 头盔: "", 胸甲: "twilightforest:naga_chestplate", 护腿: "twilightforest:naga_leggings", 靴子: "" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "ae9d7b8d-b106-4f05-bdf1-fd5595c33df9", 效果显示名称: "娜迦套 盔甲值", 数值: 8, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "02bfb2a0-3e23-4dc1-b32f-ad41c6693475", 效果显示名称: "娜迦套 护甲韧性", 数值: 4, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "1f2e5245-4f91-4e3a-8c18-dca22d9c0a72", 效果显示名称: "娜迦套 移动速度", 数值: 0.2, 计算操作: "总倍率" },
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+6",
      "§6- 盔甲韧性+2",
      "§6- 伤害减免20%",
      "§6- 你在水中行动变得迟缓",
    ],
    套装内部名称: "骨蜥套",
    部件: { 头盔: "cataclysm:bone_reptile_helmet", 胸甲: "cataclysm:bone_reptile_chestplate" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "bf21c570-a1ab-4417-984c-c1acb11b88cb", 效果显示名称: "骨蜥套 护甲值", 数值: 6, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "436dfe2c-a93a-4cab-b2c8-cfa38f72fa78", 效果显示名称: "骨蜥套 护甲韧性", 数值: 2, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "forge:swim_speed", uuid: "715d5be0-3ce4-422e-9ca9-60f44f7682e2", 效果显示名称: "骨蜥套 水中速度", 数值: -0.5, 计算操作: "增加" },
    ],
    免疫伤害列表: [{"全部伤害": 0.8}],
  },
  {
    TIP信息: [
      "§e- 魔像之心的魔血流遍你的全身",
      "§5- 你的生命获得大幅度强化",
    ],
    套装内部名称: "魔像之躯",
    饰品: ["enigmaticlegacy:golem_heart"],
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.max_health", uuid: "87694836-3538-4de8-a138-981d6d4d012c", 效果显示名称: "魔像之躯 生命强化", 数值: 0.2, 计算操作: "总倍率" },
    ]
  },
  {
    TIP信息: [
      "§e- 带上这顶绿帽子后",
      "§2- 你能承受比别人更多的伤害",
      "§2- 速度-50%",
    ],
    套装内部名称: "绿帽子",
    部件: { 头盔: "minecraft:turtle_helmet", },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "ace07de5-227e-483b-8bdd-4d1822ee6b5d", 效果显示名称: "绿帽子 移动速度", 数值: -0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "l2damagetracker:damage_absorption", uuid: "b7587283-202a-44fd-8f99-324a054dc087", 效果显示名称: "绿帽子 承受能力", 数值: 2, 计算操作: "增加" },
    ]
  },
  {
    TIP信息: [
      "§e- 同时穿戴血战沙场之证与地狱刃片护符时，激活特殊效果-血战到底",
      "§4- 血战到底：",
      "§4- 受到伤害增加25%",
      "§4- 受到煞气影响，你无法恢复生命值",
      "§4- 你造成的攻击可以穿透部分护甲",
    ],
    套装内部名称: "血战到底",
    饰品: ["enigmaticlegacy:berserk_charm", "enigmaticaddons:hell_blade_charm"],
    效果列表: [
      { 类型: "属性", 作用属性: "attributeslib:healing_received", uuid: "e5f4cab3-9f0f-490d-a8e5-f51132dc45cf", 效果显示名称: "血战到底 治疗效果", 数值: -1, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "obscure_api:penetration", uuid: "f968e994-db03-4939-8401-3351ef6f48a4", 效果显示名称: "血战到底 穿甲", 数值: 0.5, 计算操作: "增加" },
    ],
    免疫伤害列表: [{"全部伤害": 1.25}],
  },
  {
    TIP信息: [
      "§6- 速度+0.01",
      "§6- 盔甲+5",
    ],
    套装内部名称: "黑铁套装",
    部件: { 头盔: "goety:black_iron_helmet", 胸甲: "goety:black_iron_chestplate", 裤衩: "goety:black_iron_leggings", 靴子: "goety:black_iron_boots", },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "19455d83-0a7e-47d0-8f57-730cb29316cf", 效果显示名称: "黑铁套装移动速度", 数值: 0.01, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "bcda1581-caa8-40e7-b9e7-85162e5b4ae5", 效果显示名称: "黑铁套装护甲值", 数值: 5, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [
      "§6- 速度+0.04",
      "§6- 法力值+800",
      "§6- 你对法术的掌控已经登峰造极",
      "§6- 你对元素之力的掌控已经登峰造极",
    ],
    套装内部名称: "黑暗套装",
    部件: { 头盔: "goety:dark_helmet", 胸甲: "goety:dark_chestplate", 裤衩: "goety:dark_leggings", 靴子: "goety:dark_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "eec9504d-3017-437a-9aff-0ef1c5d70242", 效果显示名称: "黑暗套装移动速度", 数值: 0.04, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "c0d821bf-cfcc-437f-8e3f-f0d3420c132b", 效果显示名称: " 黑暗套装施法时间缩减", 数值: 0.4, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "4d321a67-8d8c-4e94-ab83-71e94b0fe7ac", 效果显示名称: "黑暗套装法力恢复", 数值: 0.4, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "1657b7fd-213f-4f67-aa80-b01312c49452", 效果显示名称: "黑暗套装冷却缩减", 数值: 0.4, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:max_mana", uuid: "265006dd-1edd-41bd-90c8-6dc44c99174a", 效果显示名称: "黑暗套装最大法力值", 数值: 800, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_power", uuid: "535c0700-2029-481b-9229-8e299e1fd28b", 效果显示名称: "黑暗套装法术强度", 数值: 0.4, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_resist", uuid: "593bfacb-6033-4cd6-9502-aa538a4cbab6", 效果显示名称: "黑暗套装法术抗性", 数值: 0.4, 计算操作: "总倍率" }
    ]
  },
  {
    TIP信息: [
      "§6- 速度+0.03",
      "§6- 法力值+500",
      "§6- 你对法术的掌控已经炉火纯青",
      "§6- 你对元素之力的掌控已经炉火纯青",
    ],
    套装内部名称: "远古套装",
    部件: { 头盔: "hmag:ancient_helmet", 胸甲: "hmag:ancient_chestplate", 裤衩: "hmag:ancient_leggings", 靴子: "hmag:ancient_boots", },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "eaa55f74-3fac-4726-8f71-00e5be69cf97", 效果显示名称: "远古套装移动速度", 数值: 0.03, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "1951eb74-4ef8-4ec6-b06f-c27733750e99", 效果显示名称: " 远古套装施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "0ab1f4bb-8ef3-4639-b237-32b57599c064", 效果显示名称: "远古套装法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "8fd8ef97-09db-404e-947d-63202a0cb11b", 效果显示名称: "远古套装冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:max_mana", uuid: "35672d8b-3e52-4f52-986d-15f04796cc10", 效果显示名称: "远古套装最大法力值", 数值: 500, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_power", uuid: "a8763652-2a59-4f09-b147-1cacb6b06bcd", 效果显示名称: "远古套装法术强度", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:spell_resist", uuid: "1134eb74-fbc7-4a55-adf2-c04a0be843f2", 效果显示名称: "远古套装法术抗性", 数值: 0.3, 计算操作: "总倍率" }
    ]
  },
  {
    TIP信息: [
      "§6- 速度+0.02",
      "§6- 法力值+200",
      "§6-你对法术的掌控已经驾轻就熟",
    ],
    套装内部名称: "流浪法师套装",
    部件: { 头盔: "irons_spellbooks:wandering_magician_helmet", 胸甲: "irons_spellbooks:wandering_magician_chestplate", 裤衩: "irons_spellbooks:wandering_magician_leggings", 靴子: "irons_spellbooks:wandering_magician_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "6d51bb79-758e-4656-aa99-6afd91ca96c4", 效果显示名称: "流浪法师套装移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "a48d00d7-bcbd-4817-8dc9-51a1aaf02201", 效果显示名称: " 流浪法师套装施法时间缩减", 数值: 0.2, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "93e787ae-9e6c-4fb4-8800-5880bce8a9c8", 效果显示名称: "流浪法师套装法力恢复", 数值: 0.2, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "83d4bdff-6e9c-4be6-8b63-904e4cffed0e", 效果显示名称: "流浪法师套装冷却缩减", 数值: 0.2, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:max_mana", uuid: "fc3d56e7-ae53-46ad-a812-824c11fd62e9", 效果显示名称: "流浪法师套装最大法力值", 数值: 200, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [
      "§6- 速度+0.02",
      "§6- 法力值+100",
      "§6- 你对法术的掌控已经略有所成",
      "§e- 当同时穿戴铁套和铁指环时，激活特殊效果-金光闪闪",
      "§e- 金光闪闪：",
      "§e- 你亮闪闪的",
      "§e- 幸运值+1",
    ],
    套装内部名称: "金套装",
    部件: { 头盔: "minecraft:golden_helmet", 胸甲: "minecraft:golden_chestplate", 裤衩: "minecraft:golden_leggings", 靴子: "minecraft:golden_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "58fd1ceb-4b4a-4793-bf03-9c6a3c8300e7", 效果显示名称: "金套装移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "7c4404a0-0ba9-45b9-9d96-47aea0bde286", 效果显示名称: " 金套装施法时间缩减", 数值: 0.1, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "44d97149-64b8-4075-aeca-14186da511a2", 效果显示名称: "金套装法力恢复", 数值: 0.1, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "5c7b875e-3598-4a79-972e-45f97f5aa12a", 效果显示名称: "金套装冷却缩减", 数值: 0.1, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:max_mana", uuid: "44d97149-64b8-4075-aeca-14186da511a2", 效果显示名称: "金套装最大法力值", 数值: 100, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [

    ],
    套装内部名称: "金光闪闪",
    部件: { 头盔: "minecraft:golden_helmet", 胸甲: "minecraft:golden_chestplate", 裤衩: "minecraft:golden_leggings", 靴子: "minecraft:golden_boots" },
    饰品: ["enigmaticlegacy:golden_ring"],
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.luck", uuid: "3f885043-455a-457f-87bc-92490eb18ea0", 效果显示名称: "金光闪闪 幸运", 数值: 1, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:glowing", 时长: 2 }
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+10",
      "§e- 当同时穿戴铁套和铁指环时，激活特殊效果-钢铁意志",
      "§b- 钢铁意志：",
      "§b- 伤害减免5%",
    ],
    套装内部名称: "铁套装",
    部件: { 头盔: "minecraft:iron_helmet", 胸甲: "minecraft:iron_chestplate", 裤衩: "minecraft:iron_leggings", 靴子: "minecraft:iron_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "926eabcd-b73f-440e-8310-48160ce3ff10", 效果显示名称: "铁套装护甲值", 数值: 10, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [
"§6- 伤害减免5%",
    ],
    套装内部名称: "钢铁意志",
    部件: { 头盔: "minecraft:iron_helmet", 胸甲: "minecraft:iron_chestplate", 裤衩: "minecraft:iron_leggings", 靴子: "minecraft:iron_boots" },
    饰品: ["enigmaticlegacy:iron_ring"],
    免疫伤害列表: [{"全部伤害": 0.95}],
  },
  {
    TIP信息: [
      "§6- 盔甲+5",
      "§6- 生命恢复",
    ],
    套装内部名称: "钻石套装",
    部件: { 头盔: "minecraft:diamond_helmet", 胸甲: "minecraft:diamond_chestplate", 裤衩: "minecraft:diamond_leggings", 靴子: "minecraft:diamond_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "f67972a4-454b-4370-bd95-c6283296955a", 效果显示名称: "钻石套装护甲值", 数值: 5, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:regeneration", 时长: 2 }
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+4",
      "§6- 能量潮涌",
      "§6- 生命恢复",
    ],
    套装内部名称: "潜水套",
    部件: { 头盔: "aquamirae:three_bolt_helmet", 胸甲: "aquamirae:three_bolt_suit", 裤衩: "aquamirae:three_bolt_leggings", 靴子: "aquamirae:three_bolt_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "277d5a6d-3ee8-4e6d-a211-253ec7aa3153", 效果显示名称: "潜水套护甲值", 数值: 4, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:conduit_power", uuid: "4577147c-fda6-40e5-89e5-ff9ef4419231" },
      { 类型: "药水", 药水ID: "minecraft:regeneration", uuid: "c8973fdf-5e75-4acb-8847-be39f3169a41" }
    ]
  },
  {
    TIP信息: [
      "§6- 伤害减免20%",
      "§6- 生命恢复2",
      "§6- 你对法术的掌控炉火纯青",
      "§6- 你对神圣之力的掌控无与伦比",
      "§e- 当同时穿戴生命套，心耀和生命水晶时，激活特殊效果-生生不息",
      "§2- 生生不息：",
      "§2- 免疫诅咒效果",
      "§2- 生命上限增加20",
    ],
    套装内部名称: "生命套",
    部件: { 头盔: "l2complements:totemic_gold_helmet", 胸甲: "l2complements:totemic_gold_chestplate", 裤衩: "l2complements:totemic_gold_leggings", 靴子: "l2complements:totemic_gold_boots" },
    效果列表: [
      { 类型: "药水", 药水ID: "minecraft:regeneration", 等级: 1 },
      { 类型: "属性", 作用属性: "irons_spellbooks:holy_spell_power", uuid: "3cd96a44-e176-4cb4-b2f7-0e2526e2287f", 效果显示名称: "生命套 神圣法强", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:holy_magic_resist", uuid: "a85da31e-8a4c-459e-a4b8-b15b0798c21f", 效果显示名称: "生命套 神圣抗性", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "5eb6400f-eac4-446b-b498-2b052f4ec1aa", 效果显示名称: "生命套 施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "aa5c9679-3103-4109-8fa6-e5975a175217", 效果显示名称: "生命套 法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "ec265aef-f6dd-4b5d-a18b-37dac9b56e58", 效果显示名称: "生命套 冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
    ],
    免疫伤害列表: [{"全部伤害": 0.8}],
  },
  {
    TIP信息: [
"§6- 生命上限+20",
    ],
    套装内部名称: "生生不息",
    部件: { 头盔: "l2complements:totemic_gold_helmet", 胸甲: "l2complements:totemic_gold_chestplate", 裤衩: "l2complements:totemic_gold_leggings", 靴子: "l2complements:totemic_gold_boots" },
    饰品: ["kubejs:heart_light", "artifacts:crystal_heart"],
    免疫效果列表: ["l2complements:curse",],
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.max_health", uuid: "a61a6c2c-a9de-4b21-bfad-3814844f0e4e", 效果显示名称: "生生不息 生命上限", 数值: 20, 计算操作: "增加" },
    ]
  },
  {
    TIP信息: [
      "§6- 伤害减免35%",
      "§6- 幸运值 +4",
      "§6- 幸运 2",
      "§e- 当同时穿戴以太套装和以太术石时，激活特殊效果-终极以太",
      "§3- 终极以太：",
      "§3- 速度+0.02",
      "§3- 闪避率+35%",
      "§3- 幻昙华 1",
    ],
    套装内部名称: "以太套",
    部件: { 头盔: "enigmaticlegacy:etherium_helmet", 胸甲: "enigmaticlegacy:etherium_chestplate", 裤衩: "enigmaticlegacy:etherium_leggings", 靴子: "enigmaticlegacy:etherium_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.luck", uuid: "3f885043-455a-457f-87bc-92490eb18ea0", 效果显示名称: "以太盔甲 幸运", 数值: 4, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:luck", 等级: 1 },
    ],
    免疫伤害列表: [{"全部伤害": 0.65}],
  },
  {
    TIP信息: [

    ],
    套装内部名称: "终极以太",
    部件: { 头盔: "enigmaticlegacy:etherium_helmet", 胸甲: "enigmaticlegacy:etherium_chestplate", 裤衩: "enigmaticlegacy:etherium_leggings", 靴子: "enigmaticlegacy:etherium_boots" },
    饰品: ["enigmaticaddons:etherium_core"],
    效果列表: [
      { 类型: "属性", 作用属性: "attributeslib:dodge_chance", uuid: "e3d1452f-d1b6-44c6-898a-55101ee6def8", 效果显示名称: "终极以太 闪避概率", 数值: 0.35, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "5c2b8f93-6d19-4b67-94c0-a06d4ed66826", 效果显示名称: "终极以太 移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "youkaishomecoming:phantom" },
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+15",
      "§6- 盔甲韧性+5",
      "§6- 速度+0.03",
    ],
    套装内部名称: "深渊套",
    部件: { 头盔: "aquamirae:abyssal_heaume", 胸甲: "aquamirae:abyssal_brigantine", 裤衩: "aquamirae:abyssal_leggings", 靴子: "aquamirae:abyssal_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "14e78abc-d156-4295-8831-224178ca49e9", 效果显示名称: "深渊战盔 护甲值", 数值: 15, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "8b976eab-a411-49dd-81da-257b332701d1", 效果显示名称: "深渊战盔 护甲韧性", 数值: 5.0, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "6cc61f89-ddc4-4c05-9a2d-30f1c2ebe3fb", 效果显示名称: "深渊战盔 移动速度", 数值: 0.03, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [

    ],
    套装内部名称: "晦暗深海套",
    部件: { 头盔: "aquamirae:abyssal_tiara", 胸甲: "aquamirae:abyssal_brigantine", 裤衩: "aquamirae:abyssal_leggings", 靴子: "aquamirae:abyssal_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "9a86d6e3-219c-4414-9290-571e324d4e73", 效果显示名称: "深渊头冠 护甲值", 数值: 15, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "fd17bba2-04e4-4c78-ab94-6f18e102d1e2", 效果显示名称: "深渊头冠 护甲韧性", 数值: 5.0, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "ad9c8338-8aa2-4082-9e97-4cadf6f5b884", 效果显示名称: "深渊头冠 移动速度", 数值: 0.03, 计算操作: "增加" }
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+5",
      "§6- 盔甲韧性+2",
      "§6- 抗性提升",
      "§6- 常见的火焰伤害免疫",
    ],
    套装内部名称: "合金套",
    部件: { 头盔: "minecraft:netherite_helmet", 胸甲: "minecraft:netherite_chestplate", 裤衩: "minecraft:netherite_leggings", 靴子: "minecraft:netherite_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "8beebf93-79cb-4734-8fec-9404e63b39d7", 效果显示名称: "下界合金盔甲套装 额外护甲值", 数值: 5, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "650f489a-9033-4808-ab52-b619d02f5435", 效果显示名称: "下界合金盔甲套装 额外护甲韧性", 数值: 2, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:resistance" },
    ],
    免疫伤害列表: ["火焰", "燃烧", "岩浆", "岩浆块",]
  },
  {
    TIP信息: [
      "§6- 常见的火焰伤害免疫",
      "§6- 鞘翅版本额外增加,摔落,撞击,伤害免疫",
      "§6- 免疫中毒.缓慢",
      "§6- 速度+0.02",
      "§6- 伤害减免35%",
      "§6- 排斥2",
      "§6- 抗火",
      "§6- 你对法术的掌控炉火纯青",
      "§e- 当同时穿戴滕炎套装,烈焰之核和阳灼护符时，激活特殊效果-永恒之焰",
      "§6- 永恒之焰：",
      "§6- 你对火焰之力的掌控已经无与伦比",
      "§6- 你可以释放神技",
    ],
    套装内部名称: "腾炎套",
    部件: { 头盔: "cataclysm:ignitium_helmet", 胸甲: "cataclysm:ignitium_elytra_chestplate", 裤衩: "cataclysm:ignitium_leggings", 靴子: "cataclysm:ignitium_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "3f9de9d9-428f-4a7d-a72a-a3e6f4de3862", 效果显示名称: "腾炎鞘翅盔甲 移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "01e7c56f-ec77-43c6-929f-57fb621f0827", 效果显示名称: "腾炎鞘翅盔甲 施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "7fd54383-4299-4e1d-8817-f471791054e5", 效果显示名称: "腾炎鞘翅盔甲 法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "bcd12f9e-f033-4398-802b-f0145fe4a3d9", 效果显示名称: "腾炎鞘翅盔甲 冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "药水", 药水ID: "minecraft:fire_resistance" },
      { 类型: "药水", 药水ID: "goety:repulsive", 等级: 1 }
    ],
    免疫伤害列表: ["火焰", "燃烧", "岩浆", "岩浆块", "摔落", "撞击", {"全部伤害": 0.65}]
  },
  {
    TIP信息: [
      "§6- 常见的火焰伤害免疫",
      "§6- 免疫中毒.缓慢",
      "§6- 速度+0.02",
      "§6- 伤害减免35%",
      "§6- 排斥2",
      "§6- 抗火",
      "§6- 你对法术的掌控炉火纯青",
      "§e- 当同时穿戴滕炎套装,烈焰之核和阳灼护符时，激活特殊效果-永恒之焰",
      "§6- 永恒之焰：",
      "§6- 你对火焰之力的掌控已经无与伦比",
      "§6- 你可以释放神技",
    ],
    套装内部名称: "腾炎",
    部件: { 头盔: "cataclysm:ignitium_helmet", 胸甲: "cataclysm:ignitium_chestplate", 裤衩: "cataclysm:ignitium_leggings", 靴子: "cataclysm:ignitium_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "c7b59f0f-9556-4a3c-bdc8-83d2f7471923", 效果显示名称: "腾炎标准盔甲 移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "69fd62bf-2326-48b9-af1e-897890aebedf", 效果显示名称: "腾炎标准盔甲 施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "02b46813-c4cf-49af-bc09-92b9c5d51e73", 效果显示名称: "腾炎标准盔甲 法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "f9c40567-e3b1-4123-91d8-4cb52de5492e", 效果显示名称: "腾炎标准盔甲 冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "药水", 药水ID: "minecraft:fire_resistance" },
      { 类型: "药水", 药水ID: "goety:repulsive", 等级: 1 }
    ],
    免疫伤害列表: ["火焰", "燃烧", "岩浆", "岩浆块", {"全部伤害": 0.65}]
  },
  {
    TIP信息: [

    ],
    套装内部名称: "永恒之焰",
    部件: { 头盔: "cataclysm:ignitium_helmet", 胸甲: "cataclysm:ignitium_elytra_chestplate", 裤衩: "cataclysm:ignitium_leggings", 靴子: "cataclysm:ignitium_boots" },
    饰品: ["enigmaticlegacy:blazing_core", "enigmaticaddons:scorched_charm"],
    效果列表: [
      { 类型: "属性", 作用属性: "irons_spellbooks:fire_spell_power", uuid: "1d1907b2-944b-4340-827d-419a569ec53a", 效果显示名称: "永恒之焰 火焰法强", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:fire_magic_resist", uuid: "a7674c8c-f0eb-4fc3-8849-d17a7f09db65", 效果显示名称: "永恒之焰 火焰抗性", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "药水", 药水ID: "mowziesmobs:suns_blessing", 时长: 2 }
    ]
  },
  {
    TIP信息: [

    ],
    套装内部名称: "永恒之焰2",
    部件: { 头盔: "cataclysm:ignitium_helmet", 胸甲: "cataclysm:ignitium_chestplate", 裤衩: "cataclysm:ignitium_leggings", 靴子: "cataclysm:ignitium_boots" },
    饰品: ["enigmaticlegacy:blazing_core", "enigmaticaddons:scorched_charm"],
    效果列表: [
      { 类型: "属性", 作用属性: "irons_spellbooks:fire_spell_power", uuid: "9198357a-9eb1-4316-bf56-e7cfdf516ae2", 效果显示名称: "永恒之焰 火焰法强", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:fire_magic_resist", uuid: "648ee886-596f-4953-962c-9a472a5d56a7", 效果显示名称: "永恒之焰 火焰抗性", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "药水", 药水ID: "mowziesmobs:suns_blessing", 时长: 2 }
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+20",
      "§6- 盔甲韧性+10",
      "§6- 50%伤害减免",
      "§6- 速度+0.02",
      "§6- 夜视",
    ],
    套装内部名称: "幽匿套",
    部件: { 头盔: "l2complements:sculkium_helmet", 胸甲: "l2complements:sculkium_chestplate", 裤衩: "l2complements:sculkium_leggings", 靴子: "l2complements:sculkium_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "bbd116dd-9b40-49c9-8b7b-3110f96c6656", 效果显示名称: "幽匿盔甲 护甲值", 数值: 20, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "1b553a21-a274-4e50-ac5c-c850320b9869", 效果显示名称: "幽匿盔甲 护甲韧性", 数值: 10, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "3968c35b-8e4c-4733-bc19-1ca053db3766", 效果显示名称: "幽匿盔甲 移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:night_vision", 时长: 13, }
    ],
    免疫伤害列表: [{"全部伤害": 0.5}],
  },
  {
    TIP信息: [
      "§6- 盔甲+10",
      "§6- 盔甲韧性+4",
      "§6- 夜视",
      "§6- 抗性提升1",
      "§6- 15%伤害减免",
    ],
    套装内部名称: "监守者套",
    部件: { 头盔: "deeperdarker:warden_helmet", 胸甲: "deeperdarker:warden_chestplate", 裤衩: "deeperdarker:warden_leggings", 靴子: "deeperdarker:warden_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "e24089f8-2eb8-4383-97f4-92387c606fbd", 效果显示名称: "监守者盔甲 护甲值", 数值: 10, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "721e387c-475b-4c08-b3bb-b2eefdaf25c9", 效果显示名称: "监守者盔甲 护甲韧性", 数值: 4, 计算操作: "增加" },
      { 类型: "药水", 药水ID: "minecraft:night_vision", 时长: 13, },
      { 类型: "药水", 药水ID: "minecraft:resistance", 时长: 13, }
    ],
    免疫伤害列表: [{"全部伤害": 0.85}],
  },
  {
    TIP信息: [
      "§6- 盔甲+5",
      "§6- 盔甲韧性+2",
      "§6- 你对法术的掌控达到了大成",
    ],
    套装内部名称: "合金法师套",
    部件: { 头盔: "irons_spellbooks:netherite_mage_helmet", 胸甲: "irons_spellbooks:netherite_mage_chestplate", 裤衩: "irons_spellbooks:netherite_mage_leggings", 靴子: "irons_spellbooks:netherite_mage_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "8124ffbf-c8e0-4335-a6b8-3cc8532df7ef", 效果显示名称: "下界合金法师盔甲 护甲值", 数值: 5, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "c19a3e50-280e-4b78-a04f-9b25f3adadf7", 效果显示名称: "下界合金法师盔甲 护甲韧性", 数值: 2, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "48c01d53-7560-4dc0-940a-6154d0b3278e", 效果显示名称: "下界合金法师盔甲 施法时间缩减", 数值: 0.2, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "88eb7e1f-5b20-436d-bd7d-520c1126ceff", 效果显示名称: "下界合金法师盔甲 法力恢复", 数值: 0.2, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "8fa2b3e2-0f85-44b7-b2ad-c4e055c52e95", 效果显示名称: "下界合金法师盔甲 冷却缩减", 数值: 0.2, 计算操作: "总倍率" }
    ]
  },
  {
    TIP信息: [
      "§6- 盔甲+10",
      "§6- 盔甲韧性+4",
      "§6- 伤害减免20%",
      "§6- 你对法术的掌控炉火纯青",
      "§6- 你对末影之力的掌控无与伦比",
    ],
    套装内部名称: "潜影套",
    部件: { 头盔: "l2complements:shulkerate_helmet", 胸甲: "l2complements:shulkerate_chestplate", 裤衩: "l2complements:shulkerate_leggings", 靴子: "l2complements:shulkerate_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "c5af629c-a626-48dc-9108-d4cc683e18a5", 效果显示名称: "潜影套 护甲值", 数值: 10, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:ender_spell_power", uuid: "88bf96a8-b8ed-4e68-ae10-c4339e62b407", 效果显示名称: "潜影套 末影法强", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:ender_magic_resist", uuid: "ccd21e2c-05f4-4daa-bb0d-5334a39d6552", 效果显示名称: "潜影套 末影抗性", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "63db06a5-0a8c-4f7b-8f82-74a873aaa9ce", 效果显示名称: "潜影套 施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "ca6551b8-9b8b-471b-b409-40fb6b3a2636", 效果显示名称: "潜影套 法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "c7943c6d-3c39-474f-b9f0-a2e2ee81246e", 效果显示名称: "潜影套 冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "f3b1e8d2-5c7a-4f9e-8b4d-9a0c1e2f7a3b", 效果显示名称: "潜影套 护甲韧性", 数值: 4, 计算操作: "增加" }
    ],
    免疫伤害列表: [{"全部伤害": 0.8}],
  },
  {
    TIP信息: [
      "§6- 盔甲+10",
      "§6- 盔甲韧性+4",
      "§6- 速度+0.02",
      "§6- 你在水中速度极快",
      "§6- 你对法术的掌控炉火纯青",
      "§e- 当同时穿戴海神套装,万钧之护卷轴时，激活特殊效果-风暴降临",
      "§9- 风暴降临：",
      "§9- 你对闪电之力的掌控无与伦比",
    ],
    套装内部名称: "海神套",
    部件: { 头盔: "l2complements:poseidite_helmet", 胸甲: "l2complements:poseidite_chestplate", 裤衩: "l2complements:poseidite_leggings", 靴子: "l2complements:poseidite_boots" },
    效果列表: [
      { 类型: "属性", 作用属性: "minecraft:generic.armor", uuid: "5fa3b64c-60ec-4626-8338-885432c7d380", 效果显示名称: "海神套 护甲值", 数值: 10, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.armor_toughness", uuid: "3f53be6a-7a5b-4dd7-998c-bf4086fd04f2", 效果显示名称: "海神套 护甲韧性", 数值: 4, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "minecraft:generic.movement_speed", uuid: "1661889d-8667-4a65-9474-3639facb74cf", 效果显示名称: "海神套 移动速度", 数值: 0.02, 计算操作: "增加" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cast_time_reduction", uuid: "6ee09fff-7a2c-49b0-b3ba-21799feb64f9", 效果显示名称: "海神套 施法时间缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:mana_regen", uuid: "c4720bf4-9ed0-4459-9606-17a2f49cc10a", 效果显示名称: "海神套 法力恢复", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:cooldown_reduction", uuid: "f9263dc2-ec21-4505-9b6c-940806ca5bff", 效果显示名称: "海神套 冷却缩减", 数值: 0.3, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "forge:swim_speed", uuid: "c3388d46-6195-4c35-a471-500d5a263395", 效果显示名称: "海神套 游泳速度", 数值: 1, 计算操作: "增加" },
    ]
  },
  {
    TIP信息: [
     
    ],
    套装内部名称: "我即风暴",
    部件: { 头盔: "l2complements:poseidite_helmet", 胸甲: "l2complements:poseidite_chestplate", 裤衩: "l2complements:poseidite_leggings", 靴子: "l2complements:poseidite_boots" },
    饰品:["enigmaticaddons:thunder_scroll"],
    效果列表: [
      { 类型: "属性", 作用属性: "irons_spellbooks:lightning_spell_power", uuid: "aa1602da-415f-4fb2-92b6-0a2d5d009c94", 效果显示名称: "海神套 闪电法强", 数值: 0.5, 计算操作: "总倍率" },
      { 类型: "属性", 作用属性: "irons_spellbooks:lightning_magic_resist", uuid: "c126faf4-4f6c-4ae0-8609-edfff119e69e", 效果显示名称: "海神套 闪电抗性", 数值: 0.5, 计算操作: "总倍率" },
    ]
  },
];
